/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.TreeMap;

public class DataRepRegister
extends Thread {
    private static final String TRACE_MASKT = "XSRDDRAT";
    private static final String TRACE_MASKF = "XSRDDRAF";
    private static final String TRACE_MASKD = "XSRDDRAD";
    private String machineId;
    private String[] ipAddr;
    FcsServiceId id;
    TreeMap interestedData = new TreeMap();

    DataRepRegister(String machineId, String[] ipAddr, FcsServiceId id, String[] dataSources) {
        this.machineId = machineId;
        this.ipAddr = ipAddr;
        this.id = id;
        for (int i = 0; i < dataSources.length; ++i) {
            this.interestedData.put(dataSources[i], null);
        }
    }

    public void run() {
        DataRepApp dataRepApp = DataRepApp.getDataRepApp();
        FcsServer server = FcsServer.getFcsServer();
        MachineId myMachine = server.getLocalMachineId();
        for (int j = 0; j < this.ipAddr.length; ++j) {
            Trace.trace(TRACE_MASKT, "DataRepRegister(" + this.machineId + " with " + this.ipAddr[j] + ")");
            try {
                MachineId mach = new MachineId("Dummy", "", 1.0, 1, 1, new InetAddress[]{InetAddress.getByName(this.ipAddr[j])}, new boolean[]{false});
                FcsConnection connection = FcsConnection.connect(mach, this.id);
                Socket s = connection.getSocket();
                ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(s.getInputStream()));
                ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(s.getOutputStream()));
                Object[] myObjIn = (Object[])in.readObject();
                String inString = (String)myObjIn[0];
                Trace.trace(TRACE_MASKT, "DataRepRegister.received:" + inString);
                MachineId theirMachine = (MachineId)myObjIn[1];
                if (!this.machineId.equals(theirMachine.getName())) {
                    Trace.trace(TRACE_MASKT, "DataRepRegister.received MachineId: " + theirMachine.getName() + " expected: " + this.machineId);
                    continue;
                }
                Trace.trace(TRACE_MASKT, "DataRepRegister.received Machine:" + theirMachine);
                out.writeObject("Register Me");
                out.writeObject(myMachine);
                out.flush();
                inString = (String)in.readObject();
                Trace.trace(TRACE_MASKT, "DataRepRegister.received:" + inString);
                if (inString.equals("Registered")) {
                    dataRepApp.removeDeniedMaster(theirMachine.getName());
                    Object[][] sourceVerLevels = (Object[][])in.readObject();
                    for (int i = 0; i < sourceVerLevels.length; ++i) {
                        String customDataKey = (String)sourceVerLevels[i][0];
                        if (!this.interestedData.containsKey(customDataKey) || (Long)sourceVerLevels[i][1] <= dataRepApp.getCustomDataLevel(customDataKey)) continue;
                        out.writeObject("Get Object");
                        out.writeObject(customDataKey);
                        out.flush();
                        inString = (String)in.readObject();
                        if (!inString.equals("Obj Found")) continue;
                        Serializable serObject = (Serializable)in.readObject();
                        Long serObjectLvl = (Long)in.readObject();
                        dataRepApp.updateCustomData(customDataKey, serObject, serObjectLvl);
                        String[] substData = new String[]{theirMachine.getName(), this.ipAddr[j], dataRepApp.getCustomDataName(customDataKey), serObjectLvl.toString()};
                        FrameworkEventText fet = new FrameworkEventText(886, substData);
                        new SystemEventLog(fet, "CustDataLan").log();
                    }
                } else if (inString.equals("Disabled") && !dataRepApp.isMasterDenied(theirMachine.getName())) {
                    String[] substData = new String[]{theirMachine.getName(), this.ipAddr[j]};
                    FrameworkEventText fet = new FrameworkEventText(884, substData);
                    new SystemEventLog(fet, "CustDataLan").log();
                    dataRepApp.addDeniedMaster(theirMachine.getName());
                }
                out.writeObject("Exit");
                out.flush();
                s.close();
                break;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "DataRepRegister.exception " + e);
                Trace.trace(TRACE_MASKT, e);
            }
        }
    }
}

